; ------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob - Bob Sprites Data (count: $00-$8f)
; ------------------------------------------------------------------------------------------------------------- ;
BobSpriteParts            equ  $04
BobSpriteDataLen          equ  $12
BobSpriteAmount           equ  [BobSpriteStorageX - BobSpriteStorage] / [BobSpriteDataLen * BobSpriteParts]
WobSpriteParts            equ  [BobSpriteParts * $02]
WobSpriteDataLen          equ  BobSpriteDataLen
WobSpriteAmount           equ  [WobSpriteStorageX - WobSpriteStorage] / [WobSpriteDataLen * WobSpriteParts]
; ------------------------------------------------------------------------------------------------------------- ;
NumSpriteBobRight_01      = $00 ; sprite data accessed via TabBobSprtDataPtrLo/Hi
NumSpriteBobRight_02      = $01 ; 
NumSpriteBobRight_03      = $02 ; 
NumSpriteBobRight_Min     = NumSpriteBobRight_01
NumSpriteBobRight_Max     = NumSpriteBobRight_03
NumSpriteBobLeft_01       = $03 ; 
NumSpriteBobLeft_02       = $04 ; 
NumSpriteBobLeft_03       = $05 ; 
NumSpriteBobLeft_Min      = NumSpriteBobLeft_01
NumSpriteBobLeft_Max      = NumSpriteBobLeft_03
NumSpriteBobLadder_01     = $06 ; 
NumSpriteBobLadder_02     = $07 ; 
NumSpriteBobLadderTop_01  = $08 ; 
NumSpriteBobLadderTop_02  = $09 ; 
NumSpriteBobJumpRi        = $0a ; 
NumSpriteBobJumpLe        = $0b ; 
NumSpriteBobSlideRi       = NumSpriteBobJumpRi
NumSpriteBobSlideLe       = NumSpriteBobJumpLe
; ------------------------------------------------------------------------------------------------------------- ;
NumSpriteWobRight_01      = $00 ; sprite data accessed via TabWobSprtDataPtrLo/Ho
NumSpriteWobRight_02      = $01 ; 
NumSpriteWobRight_03      = $02 ; 
NumSpriteWobLeft_01       = $03 ; 
NumSpriteWobLeft_02       = $04 ; 
NumSpriteWobLeft_03       = $05 ; 
NumSpriteWobLadder_01     = $06 ; 
NumSpriteWobLadder_02     = $07 ; 
NumSpriteWobLadderTop_01  = $08 ; 
NumSpriteWobLadderTop_02  = $09 ; 
NumSpriteWobJumpRi        = $0a ; 
NumSpriteWobJumpLe        = $0b ; 
NumSpriteWobSlideRi       = NumSpriteWobJumpRi
NumSpriteWobSlideLe       = NumSpriteWobJumpLe
; ------------------------------------------------------------------------------------------------------------- ;
BobSpriteStorage          equ  BB_BobSpriteData ; 
BobRight_01               equ  BobSpriteStorage + [BobSpriteDataLen * $00 * BobSpriteParts]] ;  
;BobRight_01_A            dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.#.#...
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $01 ; ....#.#..#......
;                         dc.b $01 ; ....#.#..#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $14 ; ...#.#...#.#.#..
;                         dc.b $28 ; ..#.#...#.#.#...
;                         dc.b $28 ; ..#.#...#.#.#...
;                         dc.b $14 ; ...#.#...#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobRight_01_B            dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $20 ; ..#.....
;                         dc.b $80 ; #.......
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobRight_01_C            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........ 
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
                          
;BobRight_01_D            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $a0 ; #.#.....
BobRight_01_X             equ  [BobSpriteStorage + [BobSpriteDataLen * $01 * BobSpriteParts]] ; 
; ----------------------  --------------------------------------------------------------------------------------- ;
BobRight_02               equ  [BobSpriteStorage + [BobSpriteDataLen * $01 * BobSpriteParts]] ; 
;BobRight_02_A            dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.#.#...
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $14 ; ...#.#...#.#.#..
;                         dc.b $28 ; ..#.#...#.#.#...
;                         dc.b $2a ; ..#.#.#...#.#...
;                         dc.b $15 ; ...#.#.#.#...#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobRight_02_B            dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $20 ; ..#.....
;                         dc.b $80 ; #.......
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $28 ; ..#.#...
;                         dc.b $44 ; .#...#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobRight_02_C            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
                          
;BobRight_02_D            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $20 ; ..#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a8 ; #.#.#...
BobRight_02_X             equ  [BobSpriteStorage + [BobSpriteDataLen * $02 * BobSpriteParts]] ; 
; ----------------------  --------------------------------------------------------------------------------------- ;
BobRight_03               equ  [BobSpriteStorage + [BobSpriteDataLen * $02 * BobSpriteParts]] ; 
;BobRight_03_A            dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.#.#...
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $14 ; ...#.#...#.#.#..
;                         dc.b $28 ; ..#.#...#.#.#...
;                         dc.b $22 ; ..#...#.#.#.#...
;                         dc.b $05 ; .....#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobRight_03_B            dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $20 ; ..#.....
;                         dc.b $80 ; #.......
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobRight_03_C            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $08 ; ....#...
;                         dc.b $20 ; ..#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $08 ; ....#...
;                         dc.b $0a ; ....#.#.
                          
;BobRight_03_D            dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $28 ; ..#.#...
BobRight_03_X             equ  [BobSpriteStorage + [BobSpriteDataLen * $03 * BobSpriteParts]] ; 
; ----------------------  --------------------------------------------------------------------------------------- ;
BobLadder_01              equ  [BobSpriteStorage + [BobSpriteDataLen * $03 * BobSpriteParts]] ; 
;BobLadder_01_A           dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ...##.#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobLadder_01_B           dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobLadder_01_C           dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $08 ; ....#...
;                         dc.b $28 ; ..#.#...
                          
;BobLadder_01_D           dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $28 ; ..#.#...
;                         dc.b $00 ; ........
BobLadder_01_X            equ  [BobSpriteStorage + [BobSpriteDataLen * $04 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLadderTop_01           equ  [BobSpriteStorage + [BobSpriteDataLen * $04 * BobSpriteParts]] ; 
;BobLadderTop_01_A        dc.b $00 ; ................
;                         dc.b $00 ; ................
;                         dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $05 ; .....#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#.#..
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#.#
;                         dc.b $15 ; ...#.#.#.#.#.#.#
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $14 ; ...#.#.....#.#..
;                         dc.b $14 ; ...#.#.....#.#..
;                         dc.b $14 ; ...#.#..........
                          
;BobLadderTop_01_B        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $54 ; .#.#.#..
;                         dc.b $14 ; ...#.#..
;                         dc.b $14 ; ...#.#..
;                         dc.b $00 ; ........
                          
;BobLadderTop_01_C        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $08 ; ....#...
;                         dc.b $28 ; ..#.#...
                          
;BobLadderTop_01_D        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $28 ; ..#.#...
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
BobLadderTop_01_X         equ  [BobSpriteStorage + [BobSpriteDataLen * $05 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobJumpSlideRi            equ  [BobSpriteStorage + [BobSpriteDataLen * $05 * BobSpriteParts]] ; 
;BobJumpSlideRi_A         dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#...#.....
;                         dc.b $0a ; ....#.#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#.........
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $14 ; ...#.#...#.#.#..
;                         dc.b $22 ; ..#...#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.#...
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#......
                          
;BobJumpSlideRi_B         dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $40 ; .#......
                          
;BobJumpSlideRi_C         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $08 ; ....#...
;                         dc.b $20 ; ..#.....
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $22 ; ..#...#.
;                         dc.b $2a ; ..#.#.#.
;                         dc.b $08 ; ....#...
                          
;BobJumpSlideRi_D         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $08 ; ....#...
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $22 ; ..#...#.
;                         dc.b $2a ; ..#.#.#.
;                         dc.b $08 ; ....#...
;                         dc.b $00 ; ........
BobJumpSlideRi_X          equ  [BobSpriteStorage + [BobSpriteDataLen * $06 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLeft_01                equ  [BobSpriteStorage + [BobSpriteDataLen * $06 * BobSpriteParts]] ; 
;BobLeft_01_A             dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#...#.#..
;                         dc.b $2a ; ..#.#.#...#.#...
;                         dc.b $2a ; ..#.#.#...#.#...
;                         dc.b $15 ; ...#.#.#...#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobLeft_01_B             dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $14 ; ...#.#..
;                         dc.b $28 ; ..#.#...
;                         dc.b $28 ; ..#.#...
;                         dc.b $14 ; ...#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobLeft_01_C             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $0a ; ....#.#.
                          
;BobLeft_01_D             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
BobLeft_01_X              equ  [BobSpriteStorage + [BobSpriteDataLen * $07 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLeft_02                equ  [BobSpriteStorage + [BobSpriteDataLen * $07 * BobSpriteParts]] ; 
;BobLeft_02_A             dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#...#.#..
;                         dc.b $2a ; ..#.#.#...#.#...
;                         dc.b $28 ; ..#.#.#.#.#.#...
;                         dc.b $11 ; ...#...#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobLeft_02_B             dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $14 ; ...#.#..
;                         dc.b $28 ; ..#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobLeft_02_C             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $02 ; ......#.
;                         dc.b $08 ; ....#...
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $08 ; ....#...
;                         dc.b $2a ; ..#.#.#.
                          
;BobLeft_02_D             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
BobLeft_02_X              equ  [BobSpriteStorage + [BobSpriteDataLen * $08 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLeft_03                equ  [BobSpriteStorage + [BobSpriteDataLen * $08 * BobSpriteParts]] ; 
;BobLeft_03_A             dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $02 ; ......#.#.#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#...#.#..
;                         dc.b $2a ; ..#.#.#...#.#...
;                         dc.b $2a ; ..#.#.#.#...#...
;                         dc.b $15 ; ...#.#.#.#.#....
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobLeft_03_B             dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $14 ; ...#.#..
;                         dc.b $28 ; ..#.#...
;                         dc.b $88 ; #...#...
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobLeft_03_C             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $08 ; ....#...
;                         dc.b $28 ; ..#.#...
                          
;BobLeft_03_D             dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $20 ; ..#.....
;                         dc.b $08 ; ....#...
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $a0 ; #.#.....
BobLeft_03_X              equ  [BobSpriteStorage + [BobSpriteDataLen * $09 * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLadder_02              equ  [BobSpriteStorage + [BobSpriteDataLen * $09 * BobSpriteParts]] ; 
;BobLadder_02_A           dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $05 ; .....#.#.#.#....
                          
;BobLadder_02_B           dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $50 ; .#.#....
                          
;BobLadder_02_C           dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $28 ; ..#.#...
;                         dc.b $00 ; ........
                          
;BobLadder_02_D           dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $28 ; ..#.#...
BobLadder_02_X            equ  [BobSpriteStorage + [BobSpriteDataLen * $0a * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobLadderTop_02           equ  [BobSpriteStorage + [BobSpriteDataLen * $0a * BobSpriteParts]] ; 
;BobLadderTop_02_A        dc.b $00 ; ................
;                         dc.b $00 ; ................
;                         dc.b $03 ; ......###.#.....
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $15 ; ...#.#.#.#.#....
;                         dc.b $15 ; ...#.#.#.#.#....
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $2a ; ..#.#.#.#.#.#...
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $55 ; .#.#.#.#.#.#.#..
;                         dc.b $55 ; .#.#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $14 ; ...#.#.....#.#..
;                         dc.b $14 ; ...#.#.....#.#..
;                         dc.b $00 ; ...........#.#..
                          
;BobLadderTop_02_B        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $c0 ; #.#.....
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $a8 ; #.#.#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; .#.#.#..
;                         dc.b $14 ; ...#.#..
;                         dc.b $14 ; ...#.#..
;                         dc.b $14 ; ...#.#..
                          
;BobLadderTop_02_C        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $28 ; ...##...
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;BobLadderTop_02_D        dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $08 ; ....#...
;                         dc.b $0a ; ....#.#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $20 ; ..#.....
;                         dc.b $20 ; ..#.....
;                         dc.b $28 ; ..#.#...
BobLadderTop_02_X         equ  [BobSpriteStorage + [BobSpriteDataLen * $0b * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
BobJumpSlideLe            equ  [BobSpriteStorage + [BobSpriteDataLen * $0b * BobSpriteParts]] ; 
;BobJumpSlideLe_A         dc.b $03 ; ......####......
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $08 ; ....#...#.#.....
;                         dc.b $2a ; ..#.#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.....
;                         dc.b $00 ; ........#.#.....
;                         dc.b $0a ; ....#.#.#.......
;                         dc.b $01 ; .......#.#......
;                         dc.b $01 ; .......#.#......
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $15 ; ...#.#.#...#.#..
;                         dc.b $2a ; ..#.#.#.#...#...
;                         dc.b $2a ; ..#.#.#.#.#.....
;                         dc.b $15 ; ...#.#.#.#.#.#..
;                         dc.b $15 ; ...#.#.#..#..#..
;                         dc.b $01 ; ....#.#..#.#....
                          
;BobJumpSlideLe_B         dc.b $c0 ; ##......
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $80 ; #.......
;                         dc.b $40 ; .#......
;                         dc.b $40 ; .#......
;                         dc.b $50 ; .#.#....
;                         dc.b $14 ; ...#.#..
;                         dc.b $88 ; #...#...
;                         dc.b $a0 ; #.#.....
;                         dc.b $54 ; .#.#.#..
;                         dc.b $54 ; ..#..#..
;                         dc.b $50 ; .#.#....
                          
;BobJumpSlideLe_C         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $80 ; #.......
;                         dc.b $20 ; ..#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $88 ; #...#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $20 ; ..#.....
;                         dc.b $00 ; ........
                          
;BobJumpSlideLe_D         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $80 ; #.......
;                         dc.b $20 ; ..#.....
;                         dc.b $08 ; ....#...
;                         dc.b $02 ; ......#.
;                         dc.b $02 ; ......#.
;                         dc.b $00 ; ........
;                         dc.b $88 ; #...#...
;                         dc.b $a8 ; #.#.#...
;                         dc.b $20 ; ..#.....
                          
;Bob_30                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
BobJumpSlideLe_X          equ  [BobSpriteStorage + [BobSpriteDataLen * $0c * BobSpriteParts]] ; 
BobSpriteStorageX         equ  [BobSpriteStorage + [BobSpriteDataLen * $0c * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobSpriteStorage          equ  BobSpriteStorageX
WobRight_01               equ  [WobSpriteStorage + [BobSpriteDataLen * $00 * WobSpriteParts]] ; 
;Bob_31                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.....#.#.#.#
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $50 ; .#.#.....#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_32                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_33                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_34                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_35                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_36                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_37                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_38                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobRight_01_X             equ  [WobSpriteStorage + [BobSpriteDataLen * $01 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobRight_02               equ  [WobSpriteStorage + [BobSpriteDataLen * $01 * WobSpriteParts]] ; 
;Bob_39                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.....#.#.#.#
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $55 ; .#.#.#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_3a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_3b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_3c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_3d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_3e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_3f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
                          
;Bob_40                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobRight_02_X             equ  [WobSpriteStorage + [BobSpriteDataLen * $02 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobRight_03               equ  [WobSpriteStorage + [BobSpriteDataLen * $02 * WobSpriteParts]] ; 
;Bob_41                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.....#.#.#.#
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_42                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_43                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_44                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_45                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_46                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_47                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
                          
;Bob_48                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobRight_03_X             equ  [WobSpriteStorage + [BobSpriteDataLen * $03 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLadder_01              equ  [WobSpriteStorage + [BobSpriteDataLen * $03 * WobSpriteParts]] ; 
;Bob_49                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_4a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_4b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_4c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
                          
;Bob_4d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
                          
;Bob_4e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
                          
;Bob_4f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
                          
;Bob_50                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
WobLadder_01_X            equ  [WobSpriteStorage + [BobSpriteDataLen * $04 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLadderTop_01           equ  [WobSpriteStorage + [BobSpriteDataLen * $04 * WobSpriteParts]] ; 
;Bob_51                   dc.b $00 ; ................
;                         dc.b $00 ; ................
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.........#.#
;                         dc.b $50 ; .#.#.........#.#
;                         dc.b $50 ; .#.#............
                          
;Bob_52                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
                          
;Bob_53                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_54                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
                          
;Bob_55                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
                          
;Bob_56                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_57                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_58                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLadderTop_01_X         equ  [WobSpriteStorage + [BobSpriteDataLen * $05 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobJumpSlideRi            equ  [WobSpriteStorage + [BobSpriteDataLen * $05 * WobSpriteParts]] ; 
;Bob_59                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.........
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.....#.#.#.#
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#....
                          
;Bob_5a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $00 ; ........
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $50 ; .#.#....
                          
;Bob_5b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_5c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
                          
;Bob_5d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
                          
;Bob_5e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_5f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
                          
;Bob_60                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobJumpSlideRi_X          equ  [WobSpriteStorage + [BobSpriteDataLen * $06 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLeft_01                equ  [WobSpriteStorage + [BobSpriteDataLen * $06 * WobSpriteParts]] ; 
;Bob_61                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.....#.#
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $55 ; .#.#.#.#.....#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_62                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_63                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; #.#.#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_64                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_65                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_66                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
                          
;Bob_67                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_68                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLeft_01_X              equ  [WobSpriteStorage + [BobSpriteDataLen * $07 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLeft_02                equ  [WobSpriteStorage + [BobSpriteDataLen * $07 * WobSpriteParts]] ; 
;Bob_69                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.....#.#
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_6a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_6b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_6c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
                          
;Bob_6d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_6e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
                          
;Bob_6f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_70                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLeft_02_X              equ  [WobSpriteStorage + [BobSpriteDataLen * $08 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLeft_03                equ  [WobSpriteStorage + [BobSpriteDataLen * $08 * WobSpriteParts]] ; 
;Bob_71                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $0a ; ....#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.....#.#
;                         dc.b $aa ; #.#.#.#.....#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
                          
;Bob_72                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_73                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_74                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
                          
;Bob_75                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
                          
;Bob_76                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $aa ; #.#.#.#.
                          
;Bob_77                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_78                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLeft_03_X              equ  [WobSpriteStorage + [BobSpriteDataLen * $09 * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLadder_02              equ  [WobSpriteStorage + [BobSpriteDataLen * $09 * WobSpriteParts]] ; 
;Bob_79                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#...#..
;                         dc.b $55 ; .#.#.#.#.#...#..
;                         dc.b $55 ; .#.#.#.#.#...#..
                          
;Bob_7a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#...#..
;                         dc.b $55 ; .#...#..
;                         dc.b $55 ; .#...#..
                          
;Bob_7b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_7c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
                          
;Bob_7d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
                          
;Bob_7e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_7f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
                          
;Bob_80                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLadder_02_X            equ  [WobSpriteStorage + [BobSpriteDataLen * $0a * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobLadderTop_02           equ  [WobSpriteStorage + [BobSpriteDataLen * $0a * WobSpriteParts]] ; 
;Bob_81                   dc.b $00 ; ................
;                         dc.b $00 ; ................
;                         dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $50 ; .#.#.........#.#
;                         dc.b $50 ; .#.#.........#.#
;                         dc.b $00 ; .............#.#
                          
;Bob_82                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
                          
;Bob_83                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
                          
;Bob_84                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_85                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_86                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_87                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
                          
;Bob_88                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $05 ; .....#.#
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $05 ; .....#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $00 ; ........
WobLadderTop_02_X         equ  [WobSpriteStorage + [BobSpriteDataLen * $0b * WobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
WobJumpSlideLe            equ  [WobSpriteStorage + [BobSpriteDataLen * $0b * WobSpriteParts]] ; 
;Bob_89                   dc.b $0f ; ....########....
;                         dc.b $ff ; ################
;                         dc.b $ff ; ################
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $a0 ; #.#.....#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $00 ; ........#.#.#.#.
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $05 ; .....#.#.#.#....
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.....#.#
;                         dc.b $aa ; #.#.#.#.#.#.....
;                         dc.b $aa ; #.#.#.#.#.#.#.#.
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $55 ; .#.#.#.#.#.#.#.#
;                         dc.b $05 ; .....#.#.#.#.#.#
                          
;Bob_8a                   dc.b $f0 ; ####....
;                         dc.b $ff ; ########
;                         dc.b $ff ; ########
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $a0 ; #.#.....
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $05 ; .....#.#
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
;                         dc.b $55 ; .#.#.#.#
                          
;Bob_8b                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $ff ; ########
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $50 ; .#.#....
;                         dc.b $50 ; .#.#....
;                         dc.b $00 ; ........
                          
;Bob_8c                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
                          
;Bob_8d                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
                          
;Bob_8e                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $aa ; #.#.#.#.
;                         dc.b $0a ; ....#.#.
                          
;Bob_8f                   dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $0a ; ....#.#.
;                         dc.b $0a ; ....#.#.
;                         dc.b $00 ; ........
;                         dc.b $a0 ; #.#.....
;                         dc.b $a0 ; #.#.....
;                         dc.b $00 ; ........
WobJumpSlideLe_X          equ  [WobSpriteStorage + [BobSpriteDataLen * $0c * WobSpriteParts]] ; 
WobSpriteStorageX         equ  [WobSpriteStorage + [BobSpriteDataLen * $0c * BobSpriteParts]] ; 
; ------------------------------------------------------------------------------------------------------------- ;
